import java.net.*;
import java.io.*;

public class EchoServerThread implements Runnable
{
  protected Socket socket;
  public EchoServerThread(Socket clientSocket)
  {
    this.socket = clientSocket;
  }
  public void run()
  {
    //Deklaracje zmiennych
    BufferedReader brinp = null;
    DataOutputStream out = null;
    String threadName = Thread.currentThread().getName();
    
    //inicjalizacja strumieni
    try{
      brinp = new BufferedReader(
        new InputStreamReader(
          socket.getInputStream()
        )
      );
      out = new DataOutputStream(socket.getOutputStream());
    }
    catch(IOException e){
      System.out.println(threadName + "| Bd przy tworzeniu strumieni " + e);
      return;
    }
    String line = null;
    
    //ptla gwna
    while(true){
      try{
        line = brinp.readLine();
        System.out.println(threadName + "| Odczytano lini: " + line);
        
        //badanie warunku zakoczenia pracy
        if((line == null) || "quit".equals(line)){
          System.out.println(threadName + "| Zakoczenie pracy z klientem: " + socket);
          socket.close();
          return;
        }
        else{ //odesanie danych do klienta
          out.writeBytes(line + "\n\r");
          System.out.println(threadName + "| Wysano lini: " + line);
        }
      }
      catch(IOException e){
        System.out.println(threadName + "| Bd wejcia-wyjcia." + e);
        return;
      }
    }
  }
}
